********************************
* This program was run on the NBER mainframe on 29 Jan 2005
* using taxsim v5.1
*******************************

clear
program drop _all
set mem 50m
set matsize 800
set more off

**********************************************************
* Here, we calculate post-tax incomes for each person (1977+ only)
**********************************************************
program define calculate_taxes
  * This next line is necessary because the 2002 & 2002 CPS's use name labels (not 2-letter codes) for the state variable.
  if year>=2001 {
  label define _state 11 ME 12 NH 13 VT 14 MA 15 RI 16 CT 21 NY 22 NJ 23 PA 31 OH 32 IN 33 IL 34 MI 35 WI 41 MN 42 IA 43 MO 44 ND 45 SD 46 NE 47 KS 51 DE 52 MD 53 DC 54 VA 55 WV 56 NC 57 SC 58 GA 59 FL 61 KY 62 TN 63 AL 64 MS 71 AR 72 LA 73 OK 74 TX 81 MT 82 ID 83 WY 84 CO 85 NM 86 AZ 87 UT 88 NV 91 WA 92 OR 93 CA 94 AK 95 HI
  label values state _state
  }
  for num 18: ren _childX childX \ replace childX=0 if _relhd==0 | _relhd>=4
  ren _fnumper familysize
  recode familysize 0=.
  recode faminc min/1=1
  decode state, gen(stcode)
  ren state state2
  gen state_soi=.
  for @ in any AL AK AZ AR CA CO CT DE DC FL GA HI ID IL IN IA KS KY LA ME MD MA MI MN MS MO MT NE NV NH NJ NM NY NC ND OH OK OR PA RI SC SD TN TX UT VT VA WA WV WI WY \ # in num 1/51: replace state_soi=# if stcode=="@"
  ren state_soi state
  
  for any agex swages dividends otherprop pensions gssi transfers rentpaid proptax otheritem childcare ui: gen X=0
  gen mstat=1
  replace mstat=2 if marital<4 & marital~=0 
  gen depx=child18
  replace agex=1 if age>65
  gen pwages=faminc
  replace pwages=faminc*0.666 if mstat==2
  replace swages=faminc*0.333 if mstat==2
  for any swages pwages: recode X min/0=0
  sort faminc
  gen taxsimid = _n
  sort taxsimid 
  save taxsim_in, replace
  taxsim
  use taxsim_out.dta, clear 
  sort taxsimid 
  merge taxsimid using taxsim_in
  tab _merge
  drop _merge
  gen faminc_posttax=(faminc-(fiitax+siitax))
  drop state frate srate fii sii fica* mstat depx agex pwages swages dividends otherprop pensions gssi transfers rentpaid proptax otheritem childcare ui mis
  ren state2 state
  compress
end

* Calculating taxes
cd /homes/nber/aleigh/bulk/
for any 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 00 01 02 03 \ num 1977/2002: use marX, clear \ recode wgt min/0=0 \ gen year=Y \ gen cpsyear=Y+1 \ ren _faminc faminc \ destring hhid, generate (hhid_b) force \ ren hhid hhid_s \ ren _marstat marital \ calculate_taxes \ sort year \ save cps_posttaxY.dta, replace

